package edu.uky.ai.lp.logic;

/**
 * A rule is a logical axiom used deduce new information.
 * 
 * @author Stephen G. Ware
 */
public class Rule {

	/** The condition under which the consequent can be deduced */
	public final Expression antecedent;
	
	/** The fact to be deduced */
	public final Fact consequent;
	
	/**
	 * Constructs a new rule with the given antecedent and consequent.
	 * 
	 * @param antecedent the condition
	 * @param consequent the fact to be deduced
	 */
	public Rule(Expression antecedent, Fact consequent) {
		this.antecedent = antecedent;
		this.consequent = consequent;
	}
	
	@Override
	public String toString() {
		return consequent + " :- " + antecedent + ".";
	}
}
